( function($) {	

	/**

	 * Appointment Type

	 */	 		

	jQuery('body').on('change', '#ga_appointment_type', function() {

		//alert( jQuery(this).val() );

		var type = jQuery(this).val();

		

		if( type == 'time_slot' ) {

			jQuery('.cmb2-id-ga-appointment-duration, .cmb2-id-ga-appointment-time').show();

		} else if( type == 'date' ) {

			jQuery('.cmb2-id-ga-appointment-duration, .cmb2-id-ga-appointment-time').hide();

		}

		

    });		

	

	/**

	 * Appointment Cancel Message

	 */	 		

	jQuery('body').on('change', '#cmb2-metabox-ga_appointment_submitdiv #post-status', function() {

		//alert( jQuery(this).val() );

		var postStatus = jQuery(this).val();

		

		if( postStatus == 'cancelled' ) {

			jQuery('#cmb2-metabox-ga_appointment_submitdiv .ga_cancel_message').removeClass('cmb2-hidden');

		} else {

			jQuery('#cmb2-metabox-ga_appointment_submitdiv .ga_cancel_message').addClass('cmb2-hidden');

		}

    });		

	

	/**

	 * Available Times Mode

	 */	 		

	jQuery('body').on('change', '.ga_service_available_times_mode', function() {

		var timeMode = jQuery(this).val();

		

		var excluded = [

			'cmb2-id-ga_service_available_times_mode',		

			'cmb2-id-ga-service-schedule-lead-time-minutes',

			'cmb2-id-ga-service-period-type',

			'cmb2-id-ga-service-max-bookings',

			'cmb2-id-ga-service-multiple-selection',

			'cmb2-id-ga-service-max-selection',

			'cmb2-id-ga-service-double-bookings',

		];	

	

		var interval = [

			'cmb2-id-ga-service-price',

			'cmb2-id-ga-service-duration',

			'cmb2-id-ga-service-cleanup',

			'cmb2-id-ga-service-capacity',

			'cmb2-id-ga-service-reduce-gaps',

			'cmb2-id-ga-service-time-format',

			'cmb2-id-ga-service-show-end-times',

			'cmb2-id-ga-service-remove-am-pm',

		];

		

		var custom = [

			'cmb2-id-ga_service_custom_slots',

			'cmb2-id-ga-service-time-format',

			'cmb2-id-ga-service-show-end-times',

			'cmb2-id-ga-service-remove-am-pm',

		];

		

		var dates = [

			'cmb2-id-ga-service-price',

			'cmb2-id-ga-service-capacity',

		];		

		

		jQuery('#cmb2-metabox-ga_services_details .cmb-row').each(function() {

			var field_class = jQuery(this).attr('class').match(/cmb2-id-[^ ]+/);

			var data = [];



			if( timeMode == 'interval' ) {

				data = interval;

			} else if( timeMode == 'custom' ) {

				data = custom;

			} else if( timeMode == 'no_slots' ) {

				data = dates;

			}			



			if( $.inArray(field_class[0], data) >= 0 ) {

				jQuery(this).removeClass('cmb2-hidden');

			} else {

				if( $.inArray(field_class[0], excluded) >= 0 ) {

					jQuery(this).removeClass('cmb2-hidden');

				} else {

					jQuery(this).addClass('cmb2-hidden');

				}

			}

		});	

    });			

	

	/**

	 * Calendar Availability Type

	 */	 

	jQuery('body').on('change', '#ga_service_period_type', function() {

		var period_type = jQuery(this).val();

		

		if( period_type == 'future_days' ) {

			jQuery('.cmb2-id-ga_service_date_range, .cmb2-id-ga_service_custom_dates').hide(); // Hide other field

			jQuery('.cmb2-id-ga-service-schedule-max-future-days').show();

		} else if( period_type == 'date_range' ) {

			jQuery('.cmb2-id-ga_service_date_range').show();

			jQuery('.cmb2-id-ga-service-schedule-max-future-days, .cmb2-id-ga_service_custom_dates').hide(); // Hide other field

		} else if( period_type == 'custom_dates' ) {

			jQuery('.cmb2-id-ga_service_custom_dates').show();

			jQuery('.cmb2-id-ga-service-schedule-max-future-days, .cmb2-id-ga_service_date_range').hide(); // Hide other field			

		}



    });	



	/**

	 * Add Color Picker to all inputs that have 'color-field' class

	 */

	jQuery('.color-field').wpColorPicker();

	

	/**

	 * Delete Services Term AJAX

	 */	   

	jQuery('body').on('click', '.ga_service_cat_delete', function() {

		if ( confirm("Are you sure?") ) {

			var term_id = jQuery(this).attr('term-id');

			var parent_li = jQuery(this).parent('li');

			

			// wp ajax

			var data = {

				'action': 'ga_service_delete_term',

				'term_id': term_id,

			};		



			jQuery.post(ga_service_delete_term_obj.ajax_url, data, function(response) {

				if ( typeof response !== 'undefined' ) {					

					if( response.success == true ) {

						parent_li.fadeOut(150, function() {

							jQuery(this).remove();

						}); 					

					}					

				}

			});			

		}	

	

    });	



	/**

	 * Deselect Services Type

	 */	   

	jQuery('body').on('change', '.ga_provider_service_type', function() {

		var service_type = jQuery(this).parent('label').attr('class');



		if( service_type == 'ga_provider_service_slots' ) {

			jQuery('#ga_dates_services input:checkbox').removeAttr("checked");

		}



		if( service_type == 'ga_provider_service_dates' ) {

			jQuery('#ga_time_slots_services input:checkbox').removeAttr("checked");

		}		



    });	



	/**

	 * ADD NEW CUSTOM DATE

	 */		

	jQuery('body').on('click', '.custom_dates_period .ga_add_custom_date', function() {

        var cloned = jQuery(this).parent('.custom_dates_period').find('#custom_dates_period .custom-date').first().clone().removeAttr( 'style' );

		jQuery(this).parent('.custom_dates_period').find('#custom_dates_period').append( cloned );

    });	

	



	/**

	 * REMOVE CUSTOM DATE

	 */	   

	jQuery('body').on('click', '#custom_dates_period .custom-date .custom-date-delete', function() {

        jQuery(this).parent('.custom-date').fadeOut(150, function() {

			jQuery(this).remove();

		}); 

    });	



	/**

	 * ADD NEW CUSTOM SLOT

	 */		

	jQuery('body').on('click', '#ga_custom_slots .add-slot', function() {

		var data = {

			'action': 'ga_service_add_slot',

		};	

		

		var $this = jQuery(this);

		

		jQuery.post(ga_service_add_slot_obj.ajax_url, data, function(response) {

			$this.closest('#ga_custom_slots').find('tbody').append( response );

		});		

    });	

	

	

	/**

	 * REMOVE CUSTOM SLOT

	 */	   

	jQuery('body').on('click', '#ga_custom_slots .slot-delete', function() {		

		if( confirm('Are you sure?') ) {

			jQuery(this).closest('tr').fadeOut(150, function() {

				jQuery(this).remove();

			}); 			

		}

    });		

	

	

} ) ( jQuery );



