<?php

/**
 * Redux Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * Redux Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Redux Framework. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package     ReduxFramework
 * @subpackage  field_import_export
 * @author      Dovy Paukstys
 * @author      Kevin Provance (kprovance)
 * @version     3.1.8
 */

// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

if( !class_exists( 'ReduxFramework_import_export' ) ) {
	/**
	 * Main ReduxFramework_import_export class
	 *
	 * @since       1.0.0
	 */
	class ReduxFramework_import_export {

		/**
		 * Field Constructor.
		 *
		 * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
		 *
		 * @since       1.0.0
		 * @access      public
		 * @return      void
		 */
		public function __construct( $field = array(), $value ='', $parent ) {
			$this->parent = $parent;
			$this->field = $field;
			$this->value = $value;

			if (!isset($this->field['full_width'])) {
				$this->field['full_width'] = true;
			}

			$args = array(
				'full_width' => $this->field['full_width']
			);

			$this->parent->import_export->field_args = $args;
		}


		/**
		 * Field Render Function.
		 *
		 * Takes the vars and outputs the HTML for the field in the settings
		 *
		 * @since       1.0.0
		 * @access      public
		 * @return      void
		 */
		public function render() {
			$this->parent->import_export->render();
		}

		/**
		 * Enqueue Function.
		 *
		 * If this field requires any scripts, or css define this function and register/enqueue the scripts/css
		 *
		 * @since       1.0.0
		 * @access      public
		 * @return      void
		 */
		public function enqueue() {
			$this->parent->import_export->enqueue();
		}
	}
}